# -*- coding: utf-8 -*-
"""Loss_Function.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1UCyfrXvlXWlqcrrlUCyaHfH-Q6BS1vaY
"""

import torch
import torch.nn as nn

####### Binary Cross-entropy
logits = torch.tensor([0.8])
probas = torch.sigmoid(logits)
target = torch.tensor([1.0])
bce_loss_fn = nn.BCELoss()
bce_logits_loss_fn = nn.BCEWithLogitsLoss()
print(f'BCE (w Probas): {bce_loss_fn(probas, target):.4f}')
print(f'BCE (w Logits): 'f'{bce_logits_loss_fn(logits, target):.4f}')

####### Categorical Cross-entropy
logits = torch.tensor([[1.5, 0.8, 2.1]])
probas = torch.softmax(logits, dim=1)
target = torch.tensor([2])
cce_loss_fn = nn.NLLLoss()
cce_logits_loss_fn = nn.CrossEntropyLoss()
print(f'CCE (w Logits): ' f'{cce_logits_loss_fn(logits, target):.4f}')
print(f'CCE (w Probas): ' f'{cce_loss_fn(torch.log(probas), target):.4f}')